' ****************************** SILABS RECEIVER **************************************************
'
' Receiver based on Si473X chip for AM and FM
'
'
' EEPROM Allocation
'
' 1,2    FM channel in 10 kHz step
' 3,4    AM channel in 1 kHz steps
' 5      FM step counter  0, 1
' 6      AM step counter  0, 1 and 2
' 7      SW step counter  0, 1, 2 and 3
' 8,9    SW channel in 1 kHz steps
'
' 20     Encoder direction
' 21     Select Program
' 30     Save Volume


$regfile = "M328Pdef.dat"                              ' Chip description
$baud = 38400
$crystal = 8000000
$hwstack = 16
$swstack = 32
$framesize = 32

Ddrb = &B00_0011                                       ' Port B direction
Portb = &B11_1100

Ddrc = &B000_0100                                      ' Port C direction
Portc = &B011_1010                                     ' Port C pullups

Ddrd = &B1111_0000                                     ' LCD Data
Portd = &B0000_1111

' *************************************** DIMENSION VARIABLES *************************************
'
' WORD LONG AND INTEGER
'
Dim Register_01 As Word
Dim Two_arguments As Word
Dim Volume As Word
Dim Volume_save As Word
Dim Previous_volume As Word                            ' read ADC6 and divide by 16 for setting volume
Dim Frequency As Word
Dim Load_fm_frequency As Long
Dim Fm_frequency As Long                               ' in 10 kHz increments
Dim Am_frequency As Word                               ' in 1 kHz increments
Dim Sw_frequency As Word
Dim Fm_mhz As Long
Dim Fm_khz As Long
Dim Ch_setup As Word
Dim Channel As Integer
Dim Low_word As Word
Dim Bandswitch As Word
Dim Previous_band As Word
Dim Bandwidth As Word
Dim Previous_bandwidth As Word
Dim Bw_value As Word
Dim Band As Word
Dim Parameter_value As Word

' BYTES

Dim Cmd As Byte                                        ' first byte to send to 473x
Dim R1a As Byte                                        ' first argument to send
Dim R2a As Byte                                        ' up to 7 arguments
Dim R3a As Byte
Dim R4a As Byte
Dim R5a As Byte
Dim R6a As Byte
Dim R7a As Byte
Dim Reply As Byte
Dim Status As Byte
Dim 100hz_timer As Byte
Dim Step_counter As Byte
Dim Low_sw As Byte
Dim High_sw As Byte
Dim Low_am As Byte
Dim High_am As Byte
Dim Low_fm As Byte
Dim High_fm As Byte
Dim I As Byte
Dim Newband As Byte
Dim Current_band As Byte
Dim Rssi As Byte
Dim Snr As Byte
Dim Second_timer As Byte
Dim Encoder_direction As Byte
Dim Si473xr As Byte
Dim Si473xw As Byte
Dim Silabs_chip As Byte
Dim Chip_ident As Byte

' ********************************* BIT ***********************************************************


Dim Frequency_up As Bit
Dim Frequency_down As Bit
Dim Memory_flag As Bit
Dim Step_bit As Bit
Dim Second_flag As Bit
Dim Alter_program As Bit


' *************************************************************************************************


' 8 BIT Timer 2 Interrupts about 100 Times / Second.

Config Timer2 = Timer , Prescale = 1024
Timer2 = 255 - 78                                      ' gives 100/sec interrupt

Readeeprom Encoder_direction , 20
If Encoder_direction = 0 Then Config Int0 = Falling    ' shaft encoder
If Encoder_direction > 0 Then Config Int0 = Rising

Config Int1 = Falling                                  ' push button switch on encoder
Config Adc = Single , Prescaler = Auto , Reference = Avcc

Config Lcd = 16 * 2
Cursor Off Noblink
Config Lcdpin = Pin , Db4 = Portd.4 , Db5 = Portd.5 , Db6 = Portd.6 , Db7 = Portd.7 , E = Portb.1 , Rs = Portb.0


' Configure the SCL and SDA pins

  Config Sda = Portc.4
  Config Scl = Portc.5
  I2cinit


Cr Alias &H0D                                          ' carriage return

Esc Alias &H06
Am Alias Portc.1
Si_reset Alias Portc.2

On Int0 Rotary_encoder
On Int1 Step_size                                      ' push button on encoder
On Timer2 100hz_interrupt

Enable Int0
Enable Int1
Enable Timer2
Enable Interrupts



  Si_reset = 0
  Waitms 100
  Si_reset = 1                                         ' raise reset line


  Gosub Initial_setup                                  ' see if 4730 or 4732

  Readeeprom Silabs_chip , 21                          ' 0 for '4730, 1 for '4732
  If Silabs_chip = 0 Then Gosub Si4730_address
  If Silabs_chip = 1 Then Gosub Si4732_address

   Cls
   If Silabs_chip = 0 Then Lcd "Si4730 Receiver"
   If Silabs_chip = 1 Then Lcd "Si4732 Receiver"
   Locate 2 , 1
   Lcd "Version 9.1"
   If Silabs_chip = 0 Then Print "Si4730 Receiver" ; Chr(cr);
   If Silabs_chip = 1 Then Print "Si4732 Receiver" ; Chr(cr);
   Print "Version 09" ; Chr(cr);

   Wait 2


   Waitus 100
   Cls
   Gosub Band_select                                   ' read select switch
   If Bandswitch = 0 Then Gosub Power_up_fm
   If Bandswitch = 1 Then Gosub Power_up_am
   If Bandswitch = 2 Then Gosub Power_up_am
   Waitms 20

   Gosub Restore_settings                              ' put up last band and frequency
   Gosub Bandwidth_select
'   Config Watchdog = 2048                                   ' watchdog timeout = 2 sec
 '  Start Watchdog
   Volume = 20
   Gosub Sv_10
   Previous_volume = Volume

' **************************************** MAIN ***************************************************
'
' Looks at various flags and branches accordingly

Main:
   Reset Watchdog                                      ' keep watchdog quiet
   Gosub Band_select                                   ' read select switch
   Gosub Set_volume                                    ' read volume pot
   If Bandswitch <> 0 Then Gosub Bandwidth_select      ' read bandwidth pot on ADC6
   If Frequency_up = 1 Then Gosub Up_value             ' encoder interrupt
   If Frequency_down = 1 Then Gosub Down_value
   If Step_bit = 1 Then Gosub Toggle_value
   If Memory_flag = 1 Then Gosub Save_channel          ' save current frequency
   If Second_flag = 1 Then Gosub Test_snr              ' check SNR every second
   Goto Main

Toggle_value:
   If Alter_program = 0 Then Gosub Change_step
   If Alter_program = 1 Then Gosub Set_parameters
   Return



Test_snr:
   If Alter_program = 1 Then Goto Ts_exit
   Second_flag = 0
   If Bandswitch = 0 Then Gosub Fm_rsq_status
   If Bandswitch > 0 Then Gosub Am_rsq_status
   Locate 2 , 8
  ' Print "Chip = " ; Silabs_chip ; Chr(cr);
   If Silabs_chip = 0 Then Lcd "          "
   If Silabs_chip = 1 Then Lcd " SNR " ; Snr ; "dB "
Ts_exit:
   Return

' Set addresses

Si4730_address:
   Si473xw = &HC6                                      ' write address
   Si473xr = &HC7                                      ' read address
   Return

Si4732_address:
   Si473xw = &H22                                      ' write address
   Si473xr = &H23                                      ' read address
   Return


' *********************************** SAVE CHANNEL **********************************************
'
' When Memory_flag is set, we save the last channel and step size used in the corresponding Band.
' Channels are saved in two bytes in EEPROM.

Save_channel:
   Memory_flag = 0                                     ' zero the flag
   If Bandswitch = 1 Then Gosub Save_am_channel
   If Bandswitch = 0 Then Gosub Save_fm_channel
   If Bandswitch = 2 Then Gosub Save_sw_channel
   Return

 Save_am_channel:
 '  Print "Save AM Channel = " ; Channel ; Chr(cr);
   Low_am = Low(channel)                               ' Two EEPROM locations to save channel
   High_am = High(channel)
   Writeeeprom High_am , 3
   Writeeeprom Low_am , 4
   Writeeeprom Step_counter , 6
   Return

 Save_fm_channel:
 '  Print "Save FM Channel = " ; Channel ; " Step Counter = " ; Step_counter ; Chr(cr);
   Low_fm = Low(channel)
   High_fm = High(channel)
   Writeeeprom High_fm , 1
   Writeeeprom Low_fm , 2
   Writeeeprom Step_counter , 5
   Return

Save_sw_channel:
  ' Print "Save SW Channel = " ; Channel ; " Step Counter = " ; Step_counter ; Chr(cr);
   Low_sw = Low(channel)
   High_sw = High(channel)
   Writeeeprom High_sw , 8
   Writeeeprom Low_sw , 9
   Writeeeprom Step_counter , 7
   Return

' ------------------------------------------------------------------------------------

Up_value:
 Frequency_up = 0

 If Bandswitch = 0 Then Gosub Fm_step_up
 If Bandswitch = 1 Then Gosub Am_step_up
 If Bandswitch = 2 Then Gosub Sw_step_up
 Print "Channel = " ; Channel ; Chr(cr);
 If Bandswitch = 0 Then Gosub Fm_channel
 If Bandswitch = 1 Then Gosub Am_channel
 If Bandswitch = 2 Then Gosub Sw_channel
 Return

Down_value:
 Frequency_down = 0

 If Bandswitch = 0 Then Gosub Fm_step_down
 If Bandswitch = 1 Then Gosub Am_step_down
 If Bandswitch = 2 Then Gosub Sw_step_down
 Print "Channel = " ; Channel ; Chr(cr);
 If Bandswitch = 0 Then Gosub Fm_channel
 If Bandswitch = 1 Then Gosub Am_channel
 If Bandswitch = 2 Then Gosub Sw_channel
 Return


Fm_step_up:
    If Step_counter = 0 Then Incr Channel
    If Step_counter = 1 Then Channel = Channel + 10
    Return

Fm_step_down:
    If Step_counter = 0 Then Decr Channel
    If Step_counter = 1 Then Channel = Channel - 10
    Return

Am_step_up:
   If Step_counter = 0 Then Incr Channel
   If Step_counter = 1 Then Channel = Channel + 9
   If Step_counter = 2 Then Channel = Channel + 100
    Return

Am_step_down:
   If Step_counter = 0 Then Decr Channel
   If Step_counter = 1 Then Channel = Channel - 9
   If Step_counter = 2 Then Channel = Channel -100
    Return

Change_step:
   Step_bit = 0
   If Bandswitch = 0 Then Gosub Fm_steps
   If Bandswitch = 1 Then Gosub Am_steps
   If Bandswitch = 2 Then Gosub Sw_steps
Cs_exit:
   Return

Am_steps:
   Incr Step_counter
   If Step_counter => 3 Then Step_counter = 0
   Locate 2 , 1
   If Step_counter = 0 Then Lcd "St 1K   "
   If Step_counter = 1 Then Lcd "St 9K   "
   If Step_counter = 2 Then Lcd "St 100K  "
   Print "St Counter = " ; Step_counter ; Chr(cr);
   Return

Fm_steps:
   Incr Step_counter
   If Step_counter => 2 Then Step_counter = 0
   Locate 2 , 1
   Writeeeprom Step_counter , 5
   If Step_counter = 0 Then Lcd "St 100K  "
   If Step_counter = 1 Then Lcd "St 1M    "

 '  Print "St Counter = " ; Step_counter ; Chr(cr);
   Return

Sw_steps:
   Incr Step_counter
   If Step_counter => 4 Then Step_counter = 0
   Locate 2 , 1
   If Step_counter = 0 Then Lcd "St 1K     "
   If Step_counter = 1 Then Lcd "St 10K    "
   If Step_counter = 2 Then Lcd "St 100K   "
   If Step_counter = 3 Then Lcd "St 1M     "
 '  Print "St Counter = " ; Step_counter ; Chr(cr);
   Return


Sw_step_up:
   If Step_counter = 0 Then Incr Channel
    If Step_counter = 1 Then Channel = Channel + 10
     If Step_counter = 2 Then Channel = Channel + 100
       If Step_counter = 3 Then Channel = Channel + 1000
    Return

Sw_step_down:
   If Step_counter = 0 Then Decr Channel
    If Step_counter = 1 Then Channel = Channel - 10
     If Step_counter = 2 Then Channel = Channel - 100
       If Step_counter = 3 Then Channel = Channel - 1000
    Return








' ************************************* AM CHANNEL **********************************************
'
' The AM band is 153 - 1730 kHz. Step size is 1, 9 or 100 kHz. This gives 1577 channels
' If a '4730 chip used, lower limit is 500 kHz. Gives 1230 channels
' The AM band is 153 - 1730 kHz. Step size is 1, 9 or 10 kHz. This gives 1577 channels

Am_channel:

   If Silabs_chip = 0 Then Gosub Am_range
   If Silabs_chip = 1 Then Gosub Lw_range
   Return

Am_range:
   If Channel < 0 Then Channel = 1230
   If Channel > 1230 Then Channel = 0
  Am_frequency = Channel
  Am_frequency = Am_frequency + 500
  Print "AM Frequency = " ; Am_frequency ; " kHz " ;   ' Chr(cr);
  Gosub Display_am_frequency
  Low_word = Am_frequency Mod 65536
  Gosub Set_am_frequency
  Return

Lw_range:
  If Channel < 0 Then Channel = 1577
  If Channel > 1577 Then Channel = 0
  Am_frequency = Channel
  Am_frequency = Am_frequency + 153
  Print "AM Frequency = " ; Am_frequency ; " kHz " ;   ' Chr(cr);
  Gosub Display_am_frequency
  Low_word = Am_frequency Mod 65536
  Gosub Set_am_frequency
  Return


' ************************************* SW CHANNEL **********************************************
'
' The SW band is 2000- 30000 kHz. Step size is 1, 10, 100, kHz or 1 MHz This gives 28,000 channels


Sw_channel:
  If Channel =< 0 Then Channel = 28000
  If Channel > 28000 Then Channel = 0
  Sw_frequency = Channel
  Sw_frequency = Sw_frequency + 2000
  Print "SW Frequency = " ; Sw_frequency ; " kHz " ;   ' Chr(cr);
  Gosub Display_sw_frequency
  Gosub Set_sw_frequency
  Return



' ************************************* FM CHANNEL **********************************************
'
' The FM band is 87 - 108 MHz. Step size is 100 kHz, so channels are 0 - 210




Fm_channel:
  If Channel < 0 Then Channel = 210
  If Channel > 210 Then Channel = 0
  Fm_frequency = Channel * 100
  Fm_frequency = Fm_frequency + 87000
  Print "FM Frequency = " ; Fm_frequency ; " kHz " ;   'Chr(cr);
  Gosub Display_fm_frequency
  Load_fm_frequency = Fm_frequency / 10                ' 100 kHz steps
  Low_word = Load_fm_frequency Mod 65536
  Gosub Set_fm_frequency
  Return


' ****************************** DISPLAY FM FREQUENCY *********************************************
'
' The FM frequency is displayed on bottom line as NNN.NN MHz
' Entry is Fm_frequency
'
Display_fm_frequency:
   Locate 1 , 1

   Fm_mhz = Fm_frequency / 1000                        ' just the MHz part
   If Fm_mhz < 100 Then Lcd " "
   Lcd Fm_mhz ; "."
   Fm_khz = Fm_frequency Mod 1000                      ' remainder
   If Fm_khz = 0 Then Lcd "000 MHz " Else Lcd Fm_khz ; " MHz     "
   Locate 2 , 1
   Readeeprom Step_counter , 5
   If Step_counter = 0 Then Lcd "St 100k  "
   If Step_counter = 1 Then Lcd "St 1MHz  "
    Return

 ' ****************************** DISPLAY AM FREQUENCY *********************************************
'
' The AM frequency is displayed on bottom line as NNN kHz
' Entry is Fm_frequency
'
Display_am_frequency:
   If Am_frequency = 500 Then Alter_program = 1 Else Alter_program = 0
   If Alter_program = 1 Then Gosub Set_parameters
   If Alter_program = 1 Then Goto Dam_exit
   Locate 1 , 1
                                                   ' top line
   If Am_frequency < 1000 Then Lcd " "
   Lcd Am_frequency ; " kHz "
   Gosub Bandwidth_select
 '  Gosub Show_am

Dam_exit:
   Return


Set_parameters:
   Cls
   Step_bit = 0
   Parameter_value = Getadc(1)
   Parameter_value = Parameter_value / 100
 '  Print "Parameter = " ; Parameter_value ; Chr(cr);
   If Parameter_value = 0 Then Gosub Reverse_encoder
 '  If Parameter_value = 10 Then Gosub Select_program

   Return

' Reverse encoder sets direction of encoder

Reverse_encoder:
   Locate 1 , 1
   Lcd "Toggle Direction"
  ' Readeeprom Encoder_direction , 20
   Toggle Encoder_direction.0
   Encoder_direction = Encoder_direction And 1
   Locate 2 , 1
   If Encoder_direction.0 = 1 Then Lcd "Direction 1"
   If Encoder_direction.0 = 0 Then Lcd "Direction 2"
   Writeeeprom Encoder_direction , 20
   If Encoder_direction = 0 Then Config Int0 = Falling ' shaft encoder
   If Encoder_direction > 0 Then Config Int0 = Rising
   Print "Direction = " ; Encoder_direction ; Chr(cr);

   Return

Select_program:
   Locate 1 , 1
   Lcd "Program Select"
   Readeeprom Silabs_chip , 21                         ' 0 for '4730, 1 for '4732
   Silabs_chip = Silabs_chip And 01
   Toggle Silabs_chip.0
   Locate 2 , 1
   If Silabs_chip = 0 Then Lcd "SiLabs 4730"
   If Silabs_chip = 1 Then Lcd "SiLabs 4732"
   Writeeeprom Silabs_chip , 21
   Return


' ****************************** DISPLAY SW FREQUENCY *********************************************
'
' The AM frequency is displayed on bottom line as NNN kHz
' Entry is Fm_frequency
'
Display_sw_frequency:
   Locate 1 , 1

   If Sw_frequency < 10000 Then Lcd " "                ' top line
   Lcd Sw_frequency ; " kHz"
   Return


' ******************************** BAND SELECET ***************************************************
'
' Band select reads switch on PORTC.1 which can be 3 values.
' +5V is AM. 0V is FM and 2.5V is SW
' Only test for MSD to get 3 values from ADC
' Test for previous value. if different then power up AM or FM


Band_select:

   Bandswitch = Getadc(3)

   Bandswitch = Bandswitch / 100                       ' 1023 becomes 10
   If Silabs_chip = 0 Then Goto Bs_10                  ' bypass the SW
   If Bandswitch = 10 Then Bandswitch = 2
Bs_10:
   If Bandswitch = 6 Then Bandswitch = 1
   If Bandswitch = 0 Then Bandswitch = 0
   If Bandswitch = Previous_band Then Goto Bs_exit
   Current_band = Bandswitch
   Previous_band = Bandswitch
   Gosub Power_down


   Locate 2 , 1
'   Print "Band " ; Bandswitch ; Chr(cr);
   If Bandswitch = 0 Then Lcd "FM : Step"
   If Bandswitch = 1 Then Lcd "St"
   If Bandswitch = 0 Then Gosub Power_up_fm
   If Bandswitch = 1 Then Gosub Power_up_am
   If Bandswitch = 2 Then Gosub Power_up_am
   Gosub Restore_settings
   Volume = Previous_volume
   Gosub Sv_10
   Gosub Bandwidth_select
Bs_exit:
  ' Gosub Mute
   Return

' ----------------------------------------------------------------------------------------------------

' Reset not used

Reset_si4732:
   Si_reset = 0
   Waitus 100
   Si_reset = 1
   Return


' ******************************** RESTORE SETTINGS ***********************************************
'
' Restore settings resets frequency and step size at power down.

Restore_settings:

   If Bandswitch = 0 Then Gosub Show_fm
   If Bandswitch = 1 Then Gosub Show_am
   If Bandswitch = 2 Then Gosub Show_sw
   Return

Show_fm:
   Readeeprom High_fm , 1
   Readeeprom Low_fm , 2
   Readeeprom Step_counter , 5
   Channel = High_fm * 256
   Channel = Channel + Low_fm
   Print "FM Channel = " ; Channel ; Chr(cr);
   Gosub Fm_channel
   Gosub Set_fm_frequency
   Return

Show_am:

   Readeeprom High_am , 3
   Readeeprom Low_am , 4
   Readeeprom Step_counter , 6
   Channel = High_am * 256
   Channel = Channel + Low_am
   Locate 2 , 1
   Lcd "St "
   If Step_counter = 0 Then Lcd "1kHz   "
   If Step_counter = 1 Then Lcd "9kHz   "
   If Step_counter = 2 Then Lcd "100kHz "
   Locate 1 , 11
   Lcd "BW"
   Print "AM Channel = " ; Channel ; Chr(cr);
   Gosub Am_channel
   Gosub Bandwidth_select
   Gosub Set_am_frequency
Sa_exit:
   Return

Show_sw:
   Readeeprom High_am , 8
   Readeeprom Low_am , 9
   Readeeprom Step_counter , 7
   Channel = High_am * 256
   Channel = Channel + Low_am
   Locate 2 , 1
   Lcd "St "
   If Step_counter = 0 Then Lcd "1kHz   "
   If Step_counter = 1 Then Lcd "9kHz   "
   If Step_counter = 2 Then Lcd "100kHz "
   If Step_counter = 3 Then Lcd "1MHz "
   Locate 1 , 11
   Lcd "BW"
   Print "SW Channel = " ; Channel ; " Step Counter = " ; Step_counter ; Chr(cr);
   Gosub Sw_channel
   Gosub Bandwidth_select
   Return
' **************************** POWER DOWN ********************************************************
'
' One byte is sent
' CMD = &H11

Power_down:
  Print "Power Down" ; Chr(cr);
  I2cstart                                             ' Generate start code
  I2cwbyte Si473xw                                     ' send address
  I2cwbyte &H11                                        ' command
  I2cstop
  Return



' **************************** FM POWER UP ************************************8*******************
'
' Three bytes are sent to power up FM RX.
' String to send is 01 10 05

Power_up_fm:
  Volume = 0
  Gosub Set_volume
  Print "Start FM, ";
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H01
  I2cwbyte &H10
  I2cwbyte &H05
  I2cstop


Puf_10:
   Waitms 150                                          ' needs to be at least 110 mS
   I2cstart
   I2cwbyte Si473xr
   I2crbyte Status , Nack
   I2cstop
   Print "Status " ; Hex(status) ; Chr(cr);
   Waitms 20
   Volume = 0

  ' Gosub Mute

   Return




' **************************** AM POWER UP ************************************8*******************
'
' Three bytes are sent to power up AM RX.
' String to send is 01 C1 05

Power_up_am:
  Gosub Mute
  Print "Start AM ";
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H01
  I2cwbyte &H11
  I2cwbyte &H05
  I2cstop

Pua_10:
  Waitms 150                                           ' needs to be at least 110 mS
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Nack
  I2cstop
  Print "Status " ; Hex(status) ; Chr(cr);
  Waitms 20
  Gosub Mute
  Return

  ' ********************************* BANDWIDTH SELECT *******************************************
'
' Bandwidth select reads ADC6 and converts voltage to Bandwidth. There are 7 values between
' 0 and 1023.
' These are converted to numbers 0 to 6.
'
'

' 0 = 6 kHz Bandwidth
' 1 = 4 kHz Bandwidth
' 2 = 3 kHz Bandwidth
' 3 = 2 kHz Bandwidth
' 4 = 1 kHz Bandwidth
' 5 = 1.8 kHz Bandwidth
' 6 = 2.5 kHz Bandwidth, gradual roll off




Bandwidth_select:
   If Alter_program = 1 Then Goto Bws_exit             ' on 500 kHz
   Bw_value = Getadc(1)
   Bw_value = Bw_value / 170
   Bandwidth = Bw_value
   Previous_bandwidth = Bandwidth
   If Bandswitch = 0 Then Goto Bws_exit
   Locate 1 , 10

   Lcd " BW " ;

   Gosub Bw_alter

   If Bandwidth = 0 Then Lcd "6.0"
   If Bandwidth = 1 Then Lcd "4.0"
   If Bandwidth = 2 Then Lcd "3.0"
   If Bandwidth = 3 Then Lcd "2.0"
   If Bandwidth = 4 Then Lcd "1.0"
   If Bandwidth = 5 Then Lcd "1.8"
   If Bandwidth = 6 Then Lcd "2.5"

   Gosub Am_bandwidth
Bws_exit:
   Return

' This puts the bandwidth in sequence from 1.0 to 6.0

Bw_alter:
   Newband = Lookup(bandwidth , Bw_sequence)
   Bandwidth = Newband
   Return

Bw_sequence:
Data 0 , 1 , 2 , 6 , 3 , 5 , 4




 '********************************** AM CHANNEL FILTER ********************************************
'
' Entry is bandwidth
' 0 = 6 kHz Bandwidth
' 1 = 4 kHz Bandwidth
' 2 = 3 kHz Bandwidth
' 3 = 2 kHz Bandwidth
' 4 = 1 kHz Bandwidth
' 5 = 1.8 kHz Bandwidth
' 6 = 2.5 kHz Bandwidth, gradual roll off
'
Am_bandwidth:

  I2cstart                                             ' Generate start code
  I2cwbyte Si473xw                                     ' send address
  I2cwbyte &H12                                        ' command
  I2cwbyte 00                                          ' send R1
  I2cwbyte &H31                                        ' send R2
  I2cwbyte 02                                          ' send R3
  I2cwbyte 00                                          ' send R4
  I2cwbyte Bandwidth                                   ' send arg5
  I2cstop
  Return




' ***************************** VOLUME CONTROL ****************************************************
'
' Volume is set by reading value on ADC6. This is 0-1023. It is divided by 16 and
' sent to command 12H as 0-63.
' String to send is 12 00 40 00 00 VOLUME
' Only send if different to previous.

'
Set_volume:

   Volume = Getadc(0)
   Volume = Volume / 16

   If Volume = Previous_volume Then Goto Sv_exit
   Previous_volume = Volume
Sv_10:
   Cmd = &H12
   R1 = 0
   R2 = &H40
   R3 = 0
   R4 = 0
   R5 = Volume
   Print "Volume " ; Volume ; Chr(cr);                 'Volume
'   Locate 1 , 13
 '  Lcd "V " ; Volume
   Volume_save = Volume
   Gosub Send_six
Sv_exit:
   Return

' Mute reduces volume to zero

Mute:
   Cmd = &H12
   R1 = 0
   R2 = &H40
   R3 = 0
   R4 = 0
   R5 = 0
   Gosub Send_six
   Waitms 250
   Return


' ****************************** FM SET FREQUENCY **************************************************
'
' Set frequency in steps of 100 kHz or 1 MHz
'
' String to send is 20 00 HI LO 00
' Where HI and LO are of the 16 bit word
' Entry is frequency in 10s of kHz


Set_fm_frequency:
   Cmd = &H20
   R1 = 0
   R2 = High(low_word)
   R3 = Low(low_word)
   R4 = 0
   Gosub Send_five
   Gosub Fm_tune_status
   Return


Get_int_status:
  Waitus 300

  I2cstart                                             ' Generate start code
  I2cwbyte Si473xw                                     ' send address
  I2cwbyte &H14
  I2cstop

  Waitus 200
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Nack
  I2cstop
  Print "Int Status " ; Hex(status) ; Chr(cr);
  Return




Fm_tune_status:
  Print "FM Tune Status = " ;
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H22
  I2cwbyte &H3
  I2cstop
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Waitms 10
  Print Hex(status) ; "," ; Hex(r1a) ; "," ; Hex(r2a) ; "," ; Hex(r3a) ; "," ;
  Print Hex(r4a) ; "," ; Hex(r5a) ; "," ; Hex(r6a) ; "," ; Hex(r7a) ; "," ; Chr(cr);
  Return






' ****************************** AM SET FREQUENCY **************************************************
'
' Set frequency in steps of 1 kHz
'
' String to send is 20 00 HI LO 00 00
' Where HI and LO are of the 16 bit word
' Entry is frequency in kHz



Set_am_frequency:
   Cmd = &H40
   R1 = 0
   R2 = High(low_word)
   R3 = Low(low_word)
   R4 = 0
   R5 = 0
   Gosub Send_six
   Gosub Am_tune_status
   Return

Am_tune_status:
  Print "AM Tune Status = " ;
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H42
  I2cwbyte &H01
  I2cstop
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Print Hex(r1a) ; "," ; Hex(r2a) ; "," ; Hex(r3a) ; "," ; Hex(r4a) ; "," ; Hex(r5a) ; "," ; Hex(r6a) ; "," ; Hex(r7a) ; "," ; Chr(cr);
  Return

' ****************************** SW SET FREQUENCY **************************************************
'
' Set frequency in steps of 1 kHz
'
' String to send is 20 00 HI LO 00 00
' Where HI and LO are of the 16 bit word
' Entry is frequency in kHz



Set_sw_frequency:
   Cmd = &H40
   R1 = 0
   R2 = High(sw_frequency)
   R3 = Low(sw_frequency)
   R4 = 0
   R5 = 0
   Gosub Send_six
   Gosub Sw_tune_status
   Return

Sw_tune_status:
  Print "SW Tune Status = ";
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H42
  I2cwbyte &H01
  I2cstop
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Waitms 20
  Print Hex(r1a) ; "," ; Hex(r2a) ; "," ; Hex(r3a) ; "," ; Hex(r4a) ; "," ; Hex(r5a) ; "," ; Hex(r6a) ; "," ; Hex(r7a) ; "," ; Chr(cr);
  Return




' ********************************** SEND SIX *****************************************************
'
' Send_six sends out address + 6 bytes to SI4732 using I2C
'

Send_six:
  Print Hex(si473xw) ; "," ; ; Hex(cmd) ; "," ; Hex(r1a) ; "," ; Hex(r2a) ;
  I2cstart                                             ' Generate start code
  I2cwbyte Si473xw                                     ' send address
  I2cwbyte Cmd                                         ' command
  I2cwbyte R1                                          ' send R1
  I2cwbyte R2                                          ' send R2
  I2cwbyte R3                                          ' send R3
  I2cwbyte R4                                          ' send R4
  I2cwbyte R5                                          ' send arg5
  I2cstop
  Print "," ; Hex(r3a) ; "," ; Hex(r4a) ; "," ; Hex(r5a) ; Chr(cr);
  Return


' ********************************** SEND FIVE ***************************************************
'
' Send_five sends out 5 bytes + address to SI4732 using I2C
'
Send_five:
  Print "Send Five Bytes " ;                           ' Chr(cr);
  I2cstart                                             ' Generate start code
  I2cwbyte Si473xw                                     ' send address
  I2cwbyte Cmd                                         ' command
  I2cwbyte R1                                          ' send R1
  I2cwbyte R2                                          ' send R2
  I2cwbyte R3                                          ' send R3
  I2cwbyte R4                                          ' send R4
  I2cstop
   Waitms 20

  Print Hex(si473xw) ; "," ; ; Hex(cmd) ; "," ; Hex(r1a) ; "," ; Hex(r2a) ;
  Print "," ; Hex(r3a) ; "," ; Hex(r4a) ; Chr(cr);
  Return



' *************************************** AM REQUEST STATUS ***************************************

Am_rsq_status:
  Waitms 20
 ' Print "AM RSQ Status = ";
  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H43
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
  Waitms 20
  Return


' *************************************** FM REQUEST STATUS ***************************************

Fm_rsq_status:

  I2cstart
  I2cwbyte Si473xw
  I2cwbyte &H23
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte Si473xr
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
   Waitms 20
 ' Print R4a ; "," ; R5a ; Chr(cr);
  Return




' ***************************** 100 HZ INTERRUPT **************************************************

100hz_interrupt:
   Timer2 = 255 - 78                                   ' reload timer
   Incr 100hz_timer
   Incr Second_timer
   If Second_timer = 100 Then Set Second_flag
   If Second_timer = 100 Then Second_timer = 0
   If 100hz_timer = 30 Then Set Memory_flag            ' in 300 mS set flag
   If 100hz_timer = 100 Then 100hz_timer = 99          ' stay there
   Return



' ******************************** ROTARY ENCODER ************************************************
'
' On INT0 falling edge, check PORTB.2. If high count up, if low, count down.

Rotary_encoder:
 '  Waitms 10                                                ' contact bounce
   If Pinb.2 = 1 Then Frequency_up = 1
   If Pinb.2 = 0 Then Frequency_down = 1
 '  Print Pinb.2;
   100hz_timer = 0                                     ' restart timer
   Return


' INT1 interrupt

Step_size:
   Step_bit = 1
   Return

' ********************************* INITIAL SETUP **************************************************
'
' Send command to Si4732 address. If status is 80H, that is chip. If status <>80H then Si3730.
Initial_setup:
  R1a = R1
  R2a = R2
  R3a = R3
  R4a = R4
  R5a = R5
  R6a = R6
  R7a = R7
  I2cstart
  I2cwbyte &H22
  I2cwbyte &H23
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte &H23
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop

  Waitms 20
  Print "Chip Ident " ; Hex(status) ; Chr(cr);
  If Status = &HFF Then Chip_ident = 0 Else Chip_ident = 1
  Writeeeprom Chip_ident , 21

' Now make sure no ridiculous numbers in EEPROM

  Readeeprom Step_counter , 6                          ' AM Step Counter
  If Step_counter =< 2 Then Goto Is_10
  If Step_counter > 2 Then Step_counter = 0
  Writeeeprom Step_counter , 6

Is_10:
  Readeeprom Step_counter , 5                          ' FM Step Counter
 If Step_counter =< 1 Then Goto Is_20
  If Step_counter > 1 Then Step_counter = 0
  Writeeeprom Step_counter , 5

Is_20:
  Readeeprom Step_counter , 7                          ' SW Step Counter
  If Step_counter =< 3 Then Goto Is_30
  If Step_counter > 3 Then Step_counter = 0
  Writeeeprom Step_counter , 5

Is_30:
   Readeeprom High_fm , 1
   Readeeprom Low_fm , 2
   Ch_setup = High_fm * 256
   Ch_setup = Ch_setup + Low_fm
   Print "FM Channel = " ; Ch_setup ; " ";
   If Ch_setup =< 210 Then Goto Is_40
   If Ch_setup > 210 Then Ch_setup = 100               ' channel # must not exceed 210
   High_fm = Ch_setup / 256
   Low_fm = Ch_setup Mod 256
   Writeeeprom High_fm , 1
   Writeeeprom Low_fm , 2



Is_40:
   Readeeprom High_am , 3
   Readeeprom Low_am , 4
   Ch_setup = High_am * 256
   Ch_setup = Ch_setup + Low_am
   Print "AM Channel = " ; Ch_setup ; " ";
   If Ch_setup =< 1578 Then Goto Is_50
   If Ch_setup > 1578 Then Ch_setup = 1000             ' channel # must not exceed 1577
   High_am = Ch_setup / 256
   Low_am = 0                                          'Ch_setup Mod 256
   Writeeeprom High_am , 3
   Writeeeprom Low_am , 4


Is_50:
   Readeeprom High_sw , 8
   Readeeprom Low_sw , 9
   Ch_setup = High_sw * 256
   Ch_setup = Ch_setup + Low_sw
   Print "SW Channel = " ; Ch_setup ; Chr(cr);
   If Ch_setup =< 28000 Then Goto Is_exit
   If Ch_setup > 28000 Then Ch_setup = 10000           ' channel # must not exceed 28000
   High_sw = Ch_setup / 256
   Low_sw = Ch_setup Mod 256
   Writeeeprom High_sw , 8
   Writeeeprom Low_sw , 9
Is_exit:
   Return